<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Cant ASCII Import Format -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads/GeometryProject">
                    <xsl:text/>
                    <xsl:for-each select="HorizontalAlignment[*/CantAlignment]/Superelevation/CantAlignment/Cant">
                        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName)), 21)"/>
                        <xsl:value-of select="cif:columnFormat(cif:formatNumber(number(@designSpeed), 0), 11)"/>
                        <xsl:value-of select="cif:columnFormat(cif:formatNumber(number(@appliedCant)), 11)"/>
                        <xsl:text>&#xd;</xsl:text>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Notes&#xd;&#xd;</xsl:text>
        <xsl:text>    Musíte vybrat nejméně jedno směrové řešení v poli Zahrnout v dialogu Nástroje &gt; XML Výpisy &gt; Geometrie.</xsl:text>
        <xsl:text>    Pro tento výpis také musíte zapnout volbu Včetně převýšení a vybrat buď Vše nebo Aktivní.</xsl:text>
        <xsl:text>Copyright 2007 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
